module My_RPG


  class My_System < RPG::System
    
    include My_DB_Text

    def to_rmxp
      com = self.cast(RPG::System)
      com.words = com.words.to_rmxp
      return com

    end


    def exporter_dialogue
      #txt = exporter_titre("System")
      #txt << @words.exporter_dialogue

      txt = @words.exporter_dialogue

      
      txt << exporter_dialogue_elements

      return txt

    end



    def exporter_dialogue_elements

      return "" if @elements.size == 0

      lignes = ""
      max = MAX_CARAC

      lignes << CARAC_EVENT * max + "\n"
      lignes << "SYSTEM ELEMENTS" + "\n"
      lignes << CARAC_FIN * max + "\n"*2

      for i in 1...@elements.size
        #next if @elements == ""
        code = "Element:#{i}"
        info = @elements[i]
        ###
        txt = ""
        carac = CARAC_ITEM
        max = MAX_CARAC


        txt << carac*(max-code.size-2)+"[#{code}]\n"
        txt << info
        txt << "\n"
        ###

        lignes << txt

      end


      return lignes
    end



    def remplacer_texte_words(list_words)
      sembl = @words.remplacer_texte(list_words)
      return sembl
    end

    def classe
      return "Element"
    end


    def remplacer_texte_elements(list_elements)

      sembl = true
      for num, element in list_elements
        
        begin
          if element != @elements[num.to_i]
            if @elements[num.to_i] == nil
              element.force_encoding("UTF-8")
              raise(DMKW_Message_Replace_Pos.new("#{self.classe}:#{num}", element))
            end

            if element.count("\n") > 0
              element.force_encoding("UTF-8")
              raise DMKW_Message_Replace_Lignes.new("[#{self.classe}:#{num}]",
                element.count("\n")+1, 1, element)
            end

            @elements[num.to_i] = element
            #pa element, @elements[num.to_i]
            sembl = false
          end
        rescue DMKW_Message_Replace_Lignes, DMKW_Message_Replace_Pos => e
          Affichage::warning(e.message)
        end
          
      end

      return sembl

    end




  end


end
